#!/bin/bash

# アーティファクトの展開
ARTIFACT_ID=YOUR_ARTIFACT_ID
tar xvzf "${ARTIFACT_ID}.tgz"

# 設定
export SUBDIR=blog
export BASE_NAME=example.on.getshifter.io
export NEW_NAME=example.com

# HTMLファイル内のリンクをサブディレクトリ対応に変換
# <a href="/"> を <a href="/blog/"> に変換（ダブルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@<a( [^/>]*)href="/@<a$1href="/$ENV{SUBDIR}/@gsi' {} \;

# <a href='/> を <a href='/blog/> に変換（シングルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  "s@<a( [^/>]*)href='/@<a\$1href='/\$ENV{SUBDIR}/@gsi" {} \;

# '/wp-content を '/blog/wp-content に変換（シングルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  "s@'/wp-content@'/\$ENV{SUBDIR}/wp-content@gsi" {} \;

# '/wp-includes を '/blog/wp-includes に変換（シングルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  "s@'/wp-includes@'/\$ENV{SUBDIR}/wp-includes@gsi" {} \;

# "/wp-content を "/blog/wp-content に変換（ダブルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@"/wp-content@"/$ENV{SUBDIR}/wp-content@gsi' {} \;

# "/wp-includes を "/blog/wp-includes に変換（ダブルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@"/wp-includes@"/$ENV{SUBDIR}/wp-includes@gsi' {} \;

# スペース/wp-content をスペース/blog/wp-content に変換
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@ /wp-content@ /$ENV{SUBDIR}/wp-content@gsi' {} \;

# スペース/wp-includes をスペース/blog/wp-includes に変換
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@ /wp-includes@ /$ENV{SUBDIR}/wp-includes@gsi' {} \;

# AMP HTMLリンクのドメインとサブディレクトリを変換（ダブルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@<link\s+rel="amphtml"\s+href="https://$ENV{BASE_NAME}/@<link rel="amphtml" href="https://$ENV{NEW_NAME}/$ENV{SUBDIR}/@gsi' {} \;

# AMP HTMLリンクのドメインとサブディレクトリを変換（シングルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  "s@<link\\s+rel='amphtml'\\s+href='https://\$ENV{BASE_NAME}/@<link rel='amphtml' href='https://\$ENV{NEW_NAME}/\$ENV{SUBDIR}/@gsi" {} \;

# AMPページのcanonicalリンクを変換（ダブルクォート）
find "${ARTIFACT_ID}/*/amp/" -name 'index.html' -exec perl -pi -e \
  's@<link\s+rel="canonical"\s+href="https://$ENV{BASE_NAME}/@<link rel="canonical" href="https://$ENV{NEW_NAME}/$ENV{SUBDIR}/@gsi' {} \;

# AMPページのcanonicalリンクを変換（シングルクォート）
find "${ARTIFACT_ID}/*/amp/" -name 'index.html' -exec perl -pi -e \
  "s@<link\\s+rel='canonical'\\s+href='https://\$ENV{BASE_NAME}/@<link rel='canonical' href='https://\$ENV{NEW_NAME}/\$ENV{SUBDIR}/@gsi" {} \;

# metaタグのcontentをドメインとサブディレクトリに変換（シングルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  "s@<meta( [^/>]*)content='https://\$ENV{BASE_NAME}/@<meta \$1content='https://\$ENV{NEW_NAME}/\$ENV{SUBDIR}/@gsi" {} \;

# metaタグのcontentをドメインとサブディレクトリに変換（ダブルクォート）
find "${ARTIFACT_ID}" -name 'index.html' -exec perl -pi -e \
  's@<meta( [^/>]*)content="https://$ENV{BASE_NAME}/@<meta $1content="https://$ENV{NEW_NAME}/$ENV{SUBDIR}/@gsi' {} \;

# RSSフィード内のリンクを変換
perl -pi -e \
  's@https://$ENV{BASE_NAME}@https://$ENV{NEW_NAME}/$ENV{SUBDIR}@gsi' \
  "${ARTIFACT_ID}/feed/index.html"

# RSSフィード内のatom:linkを変換
perl -pi -e \
  's@<atom:link( [^/>]*)href="https://$ENV{BASE_NAME}@<atom:link$1href="https://$ENV{NEW_NAME}/$ENV{SUBDIR}@gsi' \
  "${ARTIFACT_ID}/feed/index.html"